package com.androidbook.pettracker;

import com.androidbook.pettracker.PetTrackerDatabase.PetType;
import com.androidbook.pettracker.PetTrackerDatabase.Pets;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

// Ta klasa obsługuje utworzenie i wersjonowanie bazy danych aplikacji.

class PetTrackerDatabaseHelper extends SQLiteOpenHelper {

    private static final String DATABASE_NAME = "pet_tracker.db";
    private static final int DATABASE_VERSION = 1;

        
    PetTrackerDatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }
 
	@Override
	public void onCreate(SQLiteDatabase db) {
		
	    // Utworzenie tabeli PetType.
		db.execSQL("CREATE TABLE " + PetType.PETTYPE_TABLE_NAME+ " ("
                + PetType._ID + " INTEGER PRIMARY KEY AUTOINCREMENT ,"
                + PetType.PET_TYPE_NAME + " TEXT"
                + ");");
		
		// Utworzenie bazy danych Pets.
		db.execSQL("CREATE TABLE " + Pets.PETS_TABLE_NAME + " ("
                + Pets._ID + " INTEGER PRIMARY KEY AUTOINCREMENT ,"
                + Pets.PET_NAME + " TEXT,"
                + Pets.PET_TYPE_ID + " INTEGER" // to klucz obcy do tabeli gatunków
                + ");");
	}
	
	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        // Tu aktualizujemy bazę.
        // Tu należy zaimplementować operację przeniesienia danych
        // ze starej do nowej wersji bazy danych oraz zmianę jej 
        // struktury. 
        // Konieczne będzie przeniesienie lub usunięcie danych.
        // Twój ruch.
	}

	@Override
	public void onOpen(SQLiteDatabase db) {
		super.onOpen(db);
	}
}
